/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents;

import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyStructureSpawnEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerBossInfo;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractShipRaidEvent
implements IColonyRaidEvent,
IColonyStructureSpawnEvent {
    public static final String TAG_DAYS_LEFT = "pirateDaysLeft";
    public static final String TAG_SPAWNER_COUNT = "spawnerCount";
    public static final String TAG_POS = "pos";
    public static final String TAG_SPAWNERS = "spawners";
    public static final String TAG_SHIPSIZE = "shipSize";
    public static final String TAG_SHIPROTATION = "shipRotation";
    public static final String TAG_KILLED = "killed";
    private static final int MAX_LANDING_DISTANCE = 200;
    private static final int MIN_CENTER_DISTANCE = 200;
    private static final int ADD_MAX_PIRATES = 10;
    private EventStatus status = EventStatus.STARTING;
    protected final ServerBossInfo raidBar = new ServerBossInfo((ITextComponent)new StringTextComponent("Colony Raid"), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
    private int id;
    private IColony colony;
    private BlockPos spawnPoint;
    private ShipSize shipSize;
    private int daysToGo;
    private Map<Entity, UUID> raiders;
    private List<Tuple<EntityType<?>, BlockPos>> respawns;
    private int shipRotation;
    private List<BlockPos> spawners;
    private int maxSpawners;
    private PathResult spawnPathResult;

    public AbstractShipRaidEvent(@NotNull IColony colony) {
        this.daysToGo = (Integer)MineColonies.getConfig().getServer().daysUntilPirateshipsDespawn.get();
        this.raiders = new WeakHashMap<Entity, UUID>();
        this.respawns = new ArrayList();
        this.shipRotation = 0;
        this.spawners = new ArrayList<BlockPos>();
        this.maxSpawners = 0;
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void onStart() {
        BlockPos endpoint;
        Path path;
        this.status = EventStatus.PREPARING;
        this.daysToGo = (Integer)MineColonies.getConfig().getServer().daysUntilPirateshipsDespawn.get();
        CreativeBuildingStructureHandler structure = new CreativeBuildingStructureHandler(this.colony.getWorld(), this.spawnPoint, "schematics/ships/" + this.shipSize.schematicPrefix + this.getShipDesc(), new PlacementSettings(), true);
        structure.getBluePrint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.shipRotation), Mirror.NONE, this.colony.getWorld());
        if (this.spawnPathResult.isDone() && (path = this.spawnPathResult.getPath()) != null && path.func_224771_h() && ShipBasedRaiderUtils.canPlaceShipAt(endpoint = path.func_75870_c().func_224759_a().func_177977_b(), structure.getBluePrint(), this.colony.getWorld())) {
            this.spawnPoint = endpoint;
            structure = new CreativeBuildingStructureHandler(this.colony.getWorld(), this.spawnPoint, "schematics/ships/" + this.shipSize.schematicPrefix + this.getShipDesc(), new PlacementSettings(), true);
            structure.getBluePrint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.shipRotation), Mirror.NONE, this.colony.getWorld());
        }
        if (!ShipBasedRaiderUtils.canPlaceShipAt(this.spawnPoint, structure.getBluePrint(), this.colony.getWorld())) {
            this.spawnPoint = this.spawnPoint.func_177977_b();
        }
        if (!ShipBasedRaiderUtils.spawnPirateShip(this.spawnPoint, this.colony.getWorld(), this.colony, this.shipSize.schematicPrefix + this.getShipDesc(), this, this.shipRotation)) {
            this.status = EventStatus.CANCELED;
            return;
        }
        this.updateRaidBar();
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)("event.minecolonies.raidmessage_p" + this.shipSize.messageID), (Object[])new Object[]{BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName()});
        this.colony.markDirty();
    }

    protected void updateRaidBar() {
        String directionName = BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint);
        this.raidBar.func_186739_a((ITextComponent)this.getDisplayName().func_230529_a_((ITextComponent)new StringTextComponent(" - " + directionName)));
        for (PlayerEntity playerEntity : this.colony.getPackageManager().getCloseSubscribers()) {
            this.raidBar.func_186760_a((ServerPlayerEntity)playerEntity);
        }
        this.raidBar.func_186758_d(true);
    }

    protected abstract IFormattableTextComponent getDisplayName();

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        this.status = EventStatus.PROGRESSING;
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (this.spawners.size() <= 0 && this.raiders.size() == 0) {
            this.status = EventStatus.WAITING;
            return;
        }
        this.updateRaidBar();
        if (!this.respawns.isEmpty()) {
            for (Tuple<EntityType<?>, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(entry.getB(), this.colony, 200, this.spawnPoint, 200, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getA(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        this.spawners.removeIf(spawner -> this.colony.getWorld() != null && WorldUtil.isBlockLoaded((IWorld)this.colony.getWorld(), spawner) && this.colony.getWorld().func_180495_p(spawner).func_177230_c() != Blocks.field_150474_ac);
        if (this.raiders.size() < this.spawners.size() * 2 && (spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, 200, this.spawnPoint, 200, 10)) != null) {
            if (spawnPos.func_177951_i((Vector3i)this.spawnPoint) < 25.0) {
                spawnPos = ShipBasedRaiderUtils.findSpawnPosOnShip(spawnPos, this.colony.getWorld(), 3);
            }
            RaiderMobUtils.spawn(this.getNormalRaiderType(), this.shipSize.normal, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getArcherRaiderType(), this.shipSize.archer, spawnPos, this.colony.getWorld(), this.colony, this.id);
            RaiderMobUtils.spawn(this.getBossRaiderType(), this.shipSize.boss, spawnPos, this.colony.getWorld(), this.colony, this.id);
        }
        if (this.colony.getRaiderManager().areSpiesEnabled()) {
            for (Entity entity : this.getEntities()) {
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188423_x, 550));
            }
        }
    }

    @Override
    public void onFinish() {
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.pirates.sailing.away", (Object[])new Object[]{BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName(), this.colony.getName()});
        for (Entity entity : this.raiders.keySet()) {
            entity.func_70106_y();
        }
        this.raidBar.func_186758_d(false);
        this.raidBar.func_201360_b();
    }

    @Override
    public void onTileEntityBreak(TileEntity te) {
        if (te instanceof MobSpawnerTileEntity) {
            this.spawners.remove(te.func_174877_v());
            this.raidBar.func_186735_a((float)this.spawners.size() / (float)this.maxSpawners);
            if (this.spawners.isEmpty()) {
                this.daysToGo = 2;
                LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.pirates.spawners.destroyed", (Object[])new Object[]{this.colony.getName()});
            }
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo <= 0) {
            this.status = EventStatus.DONE;
        }
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        this.raiders.remove(entity);
        if (this.raiders.isEmpty() && this.spawners.isEmpty()) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.pirates.killed", (Object[])new Object[]{this.colony.getName()});
        }
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (this.raiders.keySet().size() < this.getMaxRaiders()) {
            this.raiders.put(entity, entity.func_110124_au());
        } else {
            entity.func_70106_y();
        }
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.raiders.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.raiders.remove(entity);
        this.respawns.add(new Tuple<EntityType, BlockPos>(entity.func_200600_R(), new BlockPos(entity.func_213303_ch())));
    }

    private int getMaxRaiders() {
        return this.spawners.size() * 2 + 10;
    }

    public void setShipSize(ShipSize shipSize) {
        this.shipSize = shipSize;
    }

    public void setShipRotation(int shipRotation) {
        this.shipRotation = shipRotation;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        return new ArrayList<Entity>(this.raiders.keySet());
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public List<Tuple<String, BlockPos>> getSchematicSpawns() {
        ArrayList<Tuple<String, BlockPos>> paths = new ArrayList<Tuple<String, BlockPos>>();
        paths.add(new Tuple<String, BlockPos>("schematics/ships/" + this.shipSize.schematicPrefix + this.getShipDesc(), this.spawnPoint));
        return paths;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("mc_event_id", this.id);
        compound.func_74768_a(TAG_DAYS_LEFT, this.daysToGo);
        compound.func_74768_a("eventStatus", this.status.ordinal());
        ListNBT spawnerListCompound = new ListNBT();
        for (BlockPos entry : this.spawners) {
            CompoundNBT spawnerCompound = new CompoundNBT();
            spawnerCompound.func_218657_a(TAG_POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            spawnerListCompound.add((Object)spawnerCompound);
        }
        compound.func_218657_a(TAG_SPAWNERS, (INBT)spawnerListCompound);
        compound.func_74768_a(TAG_SPAWNER_COUNT, this.maxSpawners);
        BlockPosUtil.write(compound, "spawnPos", this.spawnPoint);
        compound.func_74768_a(TAG_SHIPSIZE, this.shipSize.ordinal());
        compound.func_74768_a(TAG_SHIPROTATION, this.shipRotation);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.id = compound.func_74762_e("mc_event_id");
        this.status = EventStatus.values()[compound.func_74762_e("eventStatus")];
        this.daysToGo = compound.func_74762_e(TAG_DAYS_LEFT);
        ListNBT spawnerListCompound = compound.func_150295_c(TAG_SPAWNERS, 10);
        for (int i = 0; i < spawnerListCompound.size(); ++i) {
            this.spawners.add(NBTUtil.func_186861_c((CompoundNBT)spawnerListCompound.func_150305_b(i).func_74775_l(TAG_POS)));
        }
        this.maxSpawners = compound.func_74762_e(TAG_SPAWNER_COUNT);
        this.spawnPoint = BlockPosUtil.read(compound, "spawnPos");
        this.shipSize = ShipSize.values()[compound.func_74762_e(TAG_SHIPSIZE)];
        this.shipRotation = compound.func_74762_e(TAG_SHIPROTATION);
    }

    @Override
    public void addSpawner(BlockPos pos) {
        this.spawners.add(pos);
        ++this.maxSpawners;
    }

    public void setSpawnPath(PathResult result) {
        this.spawnPathResult = result;
    }
}

